#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// warping wormy webMod01.fsh   by    jonasfrey  
//https://www.shadertoy.com/view/XX3czn
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec2 f_o_rotd(vec2 o_trn, float n_ang_nor){
    float n_tau = radians(360.);
    float n_sin = sin(n_ang_nor*n_tau);
    float n_cos = cos(n_ang_nor*n_tau);
    mat2 o_matr = mat2(
        n_cos, -n_sin, 
        n_sin, n_cos
    );
    return o_trn*o_matr;
}
float fns(float n, float b){
    return sin(n+b)*.5+.5;
}
float fn(vec2 o_trn, float nt1, float nt2){
    float n_tau = radians(360.);

    float ndc = length(o_trn);
    float na = (1./ndc)*.06;
    vec2 o1 = f_o_rotd(o_trn, nt1*.01+na*.001);
    vec2 o2 = f_o_rotd(o_trn, na*.001);
    float n = o1.x*o1.y;
    float n2 = o2.x*o2.y;
    float nf = 2.*n_tau;
    n = fns(n*nf+nt2, 0.);
    n2 = fns(n2*nf+nt2, 0.);
    n = n*n2+(n+n2)*2.;
    return sin(n)*.5+.5;
}
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    float n_scl_min = min(iResolution.x, iResolution.y);
    vec2 o_trn = (fragCoord.xy-iResolution.xy*.5)/n_scl_min;
    //o_trn*=fns(iTime,0.)+4.;
    float n_dcntr = length(o_trn);
    o_trn*=3.;
    float ndc = length(o_trn);

    float nt = iTime*2.;
    vec3 o1 = vec3(1.,2.,3.)*0.1;
    vec3 o2 = o1*fns(nt,0.)*sin(ndc+nt)*9.;
    float nb = 1.-pow(fns(ndc*2.+iTime,0.), 1./3.);
    vec3 odc2 = vec3(
        pow(fn(o_trn, nt+o1.x, nt+o2.x),1./(fns(nt+.1,.0)*3.*nb+1.)),
        pow(fn(o_trn, nt+o1.y, nt+o2.y),1./(fns(nt+.2,.0)*3.*nb+1.)),
        pow(fn(o_trn, nt+o1.z, nt+o2.z),1./(fns(nt+.3,.0)*3.*nb+1.))
    );
    
    //odc2 = vec3(sin(n_dcntr1*n_tau*2.+iTime));
    fragColor = vec4(odc2,1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

